<!-- Modal Tambah User -->
<div class="modal fade" id="tambahJatah" tabindex="-1" aria-labelledby="tambahUserLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content shadow-lg border-0">

            <!-- Header -->
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="tambahUserLabel">
                    <i class="fas fa-user-plus me-2"></i> Tambah Jatah Cuti
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <form action="{{ route('admin.jatah-cuti.store') }}" method="POST">
                @csrf

                <div class="modal-body">

                    {{-- <div class="alert alert-info d-flex align-items-center mb-3">
                        <i class="fas fa-info-circle me-2"></i>
                        <span>Data ini digunakan untuk login sistem absensi hotel.</span>
                    </div> --}}

                    <div class="mb-3">
                        <label for="karyawan_id" class="form-label fw-semibold">Nama Karyawan</label>
                        <select name="karyawan_id" id="karyawan_id" class="form-select" required>
                            <option value="" disabled selected>-- Pilih Karyawan --</option>
                            @foreach ($karyawan as $k)
                                <option value="{{ $k->id }}">{{ $k->user->nama }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Tahun</label>
                        <input type="number" name="tahun" min="2000" placeholder="contoh = 2021 " class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Jatah Cuti</label>
                        <input type="number" name="jatah" placeholder="Masukkan jumlah jatah cuti" class="form-control">
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i> Batal
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Simpan
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>

<script>
  // 1. Ambil tahun sekarang menggunakan getFullYear()
  const tahunSekarang = new Date().getFullYear();

  // 2. Cari elemen input berdasarkan ID
  const inputTahun = document.getElementById('tahun');

  // 3. Set atribut min dan value awal ke tahun sekarang
  inputTahun.min = tahunSekarang;
  inputTahun.value = tahunSekarang;
</script>
